
/* 
 * Title : jpeg_enc.c
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

HANDLE hcom;
FILE *file;
int byte_count;
int byte_data;

void put_bit(int v)
{
	byte_data = (byte_data << 1) + v;
	byte_count++;
	if(byte_count == 8)
	{
		fputc(byte_data, file);
		if(byte_data == 0xFF)
		{
			fputc(0x00, file);
		}
		byte_count = 0;
		byte_data = 0;
	}
}

void put_flush(void)
{
	int i;
	
	if(byte_count != 0)
	{
		for(i = byte_count; i < 8; i++)
			put_bit(1);
	}
}

void put_val(int s, int v)
{
	int i;
	
	v <<= (16-s);
	
	for(i = 0; i < s; i++)
	{
		if((v & 0x8000) == 0)
			put_bit(0);
		else
			put_bit(1);
		v <<= 1;
	}
}

void put_marker(int d)
{
	put_flush();
	fputc(d, file);
}

void put_mcu(char *mcu, int *olddc)
{
	int i;
	int temp, nbits, nnnn;

	temp = mcu[0] - *olddc;
	if(temp < 0)
		temp = -temp;

	nbits = 0;
	while(temp)
	{
		nbits++;
		temp >>= 1;
	}
	put_val(4, nbits);
	
	if(0 < nbits)
	{
		temp = mcu[0] - *olddc;
		if(temp < 0)
			temp = (temp - 1) & ((1 << nbits) - 1);
		else
			temp = temp & ((1 << nbits) - 1);
		put_val(nbits, temp);
	}
	
	*olddc = mcu[0];
	
	nnnn = 0;
	for(i = 1; i < 64; i++)
	{
		temp = mcu[i];
		if(temp == 0)
		{
			nnnn++;
		}
		else
		{
			while(15 < nnnn)
			{
				put_val(8, 0x0F);	// ZRL
				nnnn = nnnn - 16;
			}
			
			if(temp < 0)
				temp = -temp;
			nbits = 0;
			while(temp)
			{
				nbits++;
				temp >>= 1;
			}
			put_val(4, nbits);
			put_val(4, nnnn);
			
			temp = mcu[i];
			if(temp < 0)
				temp = (temp-1) & ((1 << nbits) - 1);
			else
				temp = temp & ((1 << nbits) - 1);
			put_val(nbits, temp);
			
			nnnn = 0;
		}
	}
	if(nnnn != 0)
	{
		put_val(8, 0x00);	// EOB
	}
}

void get_mcu(char *mcu)
{
	int i;
	char buff;
	int buff_counter;
	
	i = 0;
	while(i < 64)
	{
		do
		{
			ReadFile(hcom, &buff, sizeof(buff), &buff_counter, NULL);
		}
		while(buff_counter == 0);
		
		if((buff & 0xC0) == 0x80)
		{
			buff &= 0x3F;
			while(buff)				// Zero Run-length
			{
				mcu[i++] = 0;
				buff--;
			}
		}
		else
		{
			mcu[i++] = buff;		// Data
		}
	}
}

void start_camera(void)
{
	char buff;
	int buff_counter;
	
	WriteFile(hcom, &buff, sizeof(buff), &buff_counter, NULL);
}

int main(int argc, char *argv[])
{
	DCB dcb;
	int i;
	int h, v;
	char mcu[8*8];
	int olddc0, olddc2, olddc3;

	if (argc < 3) return(-1);

	// --------------------------------------------------------------------- //
	hcom = CreateFile(argv[1],
	                  GENERIC_READ | GENERIC_WRITE,
	                  0,
	                  NULL,
	                  OPEN_EXISTING,
	                  FILE_ATTRIBUTE_NORMAL,
	                  NULL);
	GetCommState(hcom, &dcb);
	dcb.BaudRate = 115200;
	dcb.fBinary  = 1;	/* Binary Mode (skip EOF check) */
	dcb.fParity  = 0;	/* Enable parity checking */
	dcb.ByteSize = 8;
	dcb.Parity   = 0;	/* 0-4 = None, Odd, Even, Mark, Space */
	dcb.StopBits = 0;	/* 0-2 = 1, 1.5, 2 */
	SetCommState(hcom, &dcb);

	file = fopen(argv[2], "wb");
	byte_count = 0;
	byte_data = 0;

	start_camera();

	// --------------------------------------------------------------------- //
	put_marker(0xFF); put_marker(0xD8);			// SOI
	
	put_marker(0xFF); put_marker(0xE0);			// APP0
	put_marker(0x00); put_marker(0x10);
	put_marker('J');
	put_marker('F');
	put_marker('I');
	put_marker('F');
	put_marker(0x00);
	put_marker(0x01); put_marker(0x02);
	put_marker(1);
	put_marker(0); put_marker(96);
	put_marker(0); put_marker(96);
	put_marker(0);
	put_marker(0);

	put_marker(0xFF); put_marker(0xDB);			// DQT
	put_marker(0x00); put_marker(0x43);
	put_marker(0x00);
	for(i = 0; i < 64; i++)
	{
		put_marker(16);
	}
	
	put_marker(0xFF); put_marker(0xDB);			// DQT
	put_marker(0x00); put_marker(0x43);
	put_marker(0x01);
	for(i = 0; i < 64; i++)
	{
		put_marker(16);
	}
	
	put_marker(0xFF); put_marker(0xC4);			// DHT
	put_marker(0x00); put_marker(0x1F);
	put_marker(0x00);	// DC
	put_marker(0);		// L1
	put_marker(0);
	put_marker(0);
	put_marker(12);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);		// L16
	for(i = 0; i < 12; i++)
	{
		put_marker(i);
	}
	
	put_marker(0xFF); put_marker(0xC4);			// DHT
	put_marker(0x00); put_marker(0xC3);
	put_marker(0x10);	// AC
	put_marker(0);		// L1
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(176);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);
	put_marker(0);		// L16
	for(i = 0; i < 176; i++)
	{
		put_marker(((i >> 4) & 0x0F) | ((i << 4) & 0xF0));
	}
	
	put_marker(0xFF); put_marker(0xDD);			// DRI
	put_marker(0x00); put_marker(0x04);
	put_marker(0x00); put_marker(0x28);
	
	put_marker(0xFF); put_marker(0xC0);			// SOF0
	put_marker(0x00); put_marker(0x11);
	put_marker(0x08);
	put_marker(0x01); put_marker(0xE0);
	put_marker(0x02); put_marker(0x80);
	put_marker(0x03);	// Nf = 3
	put_marker(0x00);	//
	put_marker(0x21);
	put_marker(0x00);
	put_marker(0x01);	//
	put_marker(0x11);
	put_marker(0x01);
	put_marker(0x02);	//
	put_marker(0x11);
	put_marker(0x01);
	
	put_marker(0xFF); put_marker(0xDA);			// SOS
	put_marker(0x00); put_marker(0x0C);
	put_marker(0x03);
	put_marker(0x00);
	put_marker(0x00);
	put_marker(0x01);
	put_marker(0x00);
	put_marker(0x02);
	put_marker(0x00);
	put_marker(0x00);
	put_marker(0x3F);
	put_marker(0x00);
	
	// -- ENTROPY-ENCODED -------------------------------------------------- //
	for(v = 0; v < 614400; v+=10240)
	{
		olddc0 = olddc2 = olddc3 = 0;
		for(h = 0; h < 10240; h+=256)
		{
			// -- Y0
			get_mcu(mcu);
			put_mcu(mcu, &olddc0);
			// -- Y1
			get_mcu(mcu);
			put_mcu(mcu, &olddc0);
			// -- Cb
			get_mcu(mcu);
			put_mcu(mcu, &olddc2);
			// -- Cr
			get_mcu(mcu);
			put_mcu(mcu, &olddc3);
		}
		if (v < 604160)
		{
			put_marker(0xFF); put_marker(0xD0 + ((v / 10240) & 7));	// RST
		}
		printf("*");
	}
	printf("\n");
	
	// --------------------------------------------------------------------- //
	put_marker(0xFF); put_marker(0xD9);			// EOI
	
	// --------------------------------------------------------------------- //
	if(file != NULL) fclose(file);
	if(hcom != INVALID_HANDLE_VALUE) CloseHandle(hcom);
	
	return(0);
}
