
------------------------------------------------------------------------------
-- Title       : IOP.VHD
-- Description : BLANCA I/O Processor for E!Kit-CAM-TTL
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 08/31/2007
------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity IOP is
	port (

	-- VXeZbg
		SYS_nRST1 : in std_logic;								-- Zbg(ZbgXCb`)
		SYS_nRST2 : in std_logic;								-- Zbg(JTAGoR)

	-- [JoXMs
		L_CLK   : out std_logic;								-- NbN
		L_nCS   : in std_logic_vector(7 downto 0);				-- `bvZNg
		L_A     : in std_logic_vector(28 downto 0);				-- AhXoX
		L_nBE   : in std_logic_vector(3 downto 0);				-- oCgCl[u
		L_nRD   : in std_logic;									-- [h
		L_nWR   : in std_logic;									-- Cg
		L_RnW   : in std_logic;									-- [h/Cg
		L_D     : inout std_logic_vector(31 downto 0);			-- f[^oX
		L_nWAIT : out std_logic;								-- EFCgo

	-- I/OvZbT荞ݏo
		IOP_nINT : inout std_logic_vector(15 downto 0);			-- I/OvZbT荞ݏo(_)

	-- PCIoXMs
		PCI_CLK     : in std_logic;								-- PCIoXNbN
		PCI_nRST    : in std_logic;								-- PCIoXZbg
		PCI_AD      : inout std_logic_vector(31 downto 0);		-- AhX/f[^oX
		PCI_CnBE    : in std_logic_vector(3 downto 0);			-- PCIoXR}h/oCgCl[u
		PCI_nFRAME  : in std_logic;								-- t[
		PCI_nIRDY   : in std_logic;								-- CjVG[^fB
		PCI_nDEVSEL : inout std_logic;							-- foCXZNV
		PCI_nTRDY   : inout std_logic;							-- ^[QbgfB
		PCI_nSTOP   : inout std_logic;							-- ]Xgbvv
		PCI_PAR     : inout std_logic;							-- peBrbg(o͂̂)
		PCI_nPERR   : inout std_logic;							-- peBG[
		PCI_nSERR   : inout std_logic;							-- VXeG[
		PCI_nINTA   : inout std_logic;							-- 荞ݏo INTA#
		PCI_nINTB   : inout std_logic;							-- 荞ݏo INTB#
		PCI_nINTC   : inout std_logic;							-- 荞ݏo INTC#
		PCI_nINTD   : inout std_logic;							-- 荞ݏo INTD#
		PCI_nREQ    : out std_logic;							-- oXgpvM
		PCI_nGNT    : in std_logic;								-- oXgpM

	-- LANMs
		LAN_TxCLK : in std_logic;								-- MNbN
		LAN_TxERR : out std_logic;								-- MG[
		LAN_TxEN  : out std_logic;								-- MCl[u
		LAN_TxD   : out std_logic_vector(3 downto 0);			-- Mf[^
		LAN_RxCLK : in std_logic;								-- MNbN
		LAN_RxERR : in std_logic;								-- MG[
		LAN_RxDV  : in std_logic;								-- MCl[u
		LAN_RxD   : in std_logic_vector(3 downto 0);			-- Mf[^
		LAN_COL   : in std_logic;								-- Փˌo
		LAN_CRS   : in std_logic;								-- LAZX
		LAN_MDC   : out std_logic;								-- PHY`bvʐMNbN
		LAN_MDIO  : inout std_logic;							-- PHY`bvʐMf[^

	-- IDEMs
		IDE_nRST  : out std_logic;								-- Zbg
		IDE_nDIOR : out std_logic;								-- [h
		IDE_nDIOW : out std_logic;								-- Cg
		IDE_INTRQ : in std_logic;								-- 荞
		IDE_IORDY : in std_logic;								-- I/OfB
		IDE_DMARQ : in std_logic;								-- DMANGXg
		IDE_DMACK : out std_logic;								-- DMAANmbW
		IDE_nCS   : out std_logic_vector(1 downto 0);			-- `bvZNg
		IDE_DA    : out std_logic_vector(2 downto 0);			-- AhX
		IDE_DD    : inout std_logic_vector(15 downto 0);		-- f[^oX
		IDE_DIR   : out std_logic;								-- f[^oXobt@

	-- CompactFlashMs
		CF_nBUFEN  : out std_logic;								-- oXobt@Cl[u
		CF_nPOWEN  : out std_logic;								-- dCl[u
		CF_RESET   : out std_logic;								-- Zbg
		CF_nCDx    : inout std_logic;							-- J[hfBeNg
		CF_nCE1    : inout std_logic;							-- `bvCl[u1
		CF_nCE2    : inout std_logic;							-- `bvCl[u2
		CF_nREG    : inout std_logic;							-- R/Agr[gI
		CF_nOE     : inout std_logic;							-- AEgvbgCl[u
		CF_nWE     : inout std_logic;							-- CgCl[u
		CF_nIORD   : inout std_logic;							-- I/O[h
		CF_nIOWR   : inout std_logic;							-- I/OCg
		CF_nIOCS16 : inout std_logic;							-- I/OWX^I
		CF_nIREQ   : inout std_logic;							-- 荞
		CF_nWAIT   : inout std_logic;							-- EFCg
		CF_A       : inout std_logic_vector(10 downto 0);		-- AhXoX
		CF_D       : inout std_logic_vector(15 downto 0);		-- f[^oX

	-- USBzXg/^[QbgMs
		U_F48M      : in std_logic;								-- USBNbN(48MHz)
		USB1_Dp     : inout std_logic;							-- USBzXg1 D+
		USB1_Dn     : inout std_logic;							-- USBzXg1 D-
		USB2_Dp     : inout std_logic;							-- USBzXg2 D+
		USB2_Dn     : inout std_logic;							-- USBzXg2 D-
		USB3_Dp     : inout std_logic;							-- USB^[Qbg D+
		USB3_Dn     : inout std_logic;							-- USB^[Qbg D-
		USB3_DISCON : out std_logic;							-- USB^[QbgCl[u

	-- PS/2C^[tF[XMs
		PS2a_CLK  : inout std_logic;							-- |[ga NbN
		PS2a_DATA : inout std_logic;							-- |[ga f[^
		PS2b_CLK  : inout std_logic;							-- |[gb NbN
		PS2b_DATA : inout std_logic;							-- |[gb f[^

	-- COM|[gMs
		COM1_TxD : out std_logic;								-- TxD
		COM1_RxD : in std_logic;								-- RxD
		COM1_RTS : out std_logic;								-- RTS
		COM1_CTS : in std_logic;								-- CTS

		-- AiORGBMs
		V_nHSYNC : in std_logic;								-- gp
		V_nVSYNC : in std_logic									-- gp

	);
end IOP;

architecture RTL of IOP is

	-- ***** BLANCAVXeoXM ***** --
	signal RST : std_logic;
	signal CLK : std_logic;

	-- ***** E!Kit-CAM-TTL M ***** --
	signal RESET     : std_logic;
	signal RESET_CNT : integer range 0 to 960000;

begin

	-- ***** VXeNbN/ZbgM ***** --
	RST <= (not SYS_nRST1) or (not SYS_nRST2);
	CLK <= U_F48M;

	-- ***** E!Kit-CAM-TTL M ***** --

	-- d(CF_POW)肷鎞Ԃo(20ms)烊ZbgB
	-- TPS2041f[^V[gQƂ̂

	CF_nBUFEN <= '0';
	CF_nPOWEN <= '0';

	process(CLK, RST) begin
		if (RST = '1') then
			RESET       <= '0';
			RESET_CNT <= 0;
		elsif (CLK'event and CLK = '1') then
			if (RESET_CNT = 960000) then		-- 20ms(@48MHz)
				RESET <= '1';
			else
				RESET_CNT <= RESET_CNT + 1;
			end if;
		end if;
	end process;

	CF_RESET <= RESET;			-- RESET
	CF_A(9)  <= CLK;			-- CLKIN
	CF_A(4)  <= '0';			-- STANDBY
	CF_A(6)  <= '0';			-- VDDDIS
	CF_A(5)  <= '1';			-- SADDR

	CF_nCE1     <= '0' when (IOP_nINT(4) = '0') else 'Z';		-- SCLK
	IOP_nINT(5) <= CF_nCE1;
	CF_D(7)     <= '0' when (IOP_nINT(6) = '0') else 'Z';		-- SDATA
	IOP_nINT(7) <= CF_D(7);

	IOP_nINT(0) <= RESET;		-- RESET
	L_CLK       <= CF_nWE;		-- PIXCLK
	IOP_nINT(3) <= CF_D(15);	-- LINE
	IOP_nINT(2) <= CF_nCE2;		-- FRAME
	L_D(16)     <= CF_D(3);		-- DOUT(0)
	L_D(17)     <= CF_D(11);	-- DOUT(1)
	L_D(18)     <= CF_D(4);		-- DOUT(2)
	L_D(19)     <= CF_D(12);	-- DOUT(3)
	L_D(20)     <= CF_D(5);		-- DOUT(4)
	L_D(21)     <= CF_D(13);	-- DOUT(5)
	L_D(22)     <= CF_D(6);		-- DOUT(6)
	L_D(23)     <= CF_D(14);	-- DOUT(7)

	-- ***** I/OvZbT荞 gp ***** --
	IOP_nINT(1)           <= '1';
	IOP_nINT(15 downto 8) <= (others => '1');

	-- ***** [JoX gp ***** --
	L_D(15 downto 0)  <= (others => 'Z');
	L_D(31 downto 24) <= (others => 'Z');
	L_nWAIT           <= '1';

	-- ***** PCIoX gp ***** --
	PCI_AD      <= (others => 'Z');
	PCI_nDEVSEL <= 'Z';
	PCI_nTRDY   <= 'Z';
	PCI_nSTOP   <= 'Z';
	PCI_PAR     <= 'Z';
	PCI_nPERR   <= 'Z';
	PCI_nSERR   <= 'Z';
	PCI_nINTA   <= 'Z';
	PCI_nINTB   <= 'Z';
	PCI_nINTC   <= 'Z';
	PCI_nINTD   <= 'Z';
	PCI_nREQ    <= '1';

	-- ***** LAN gp ***** --
	LAN_TxERR <= '0';
	LAN_TxEN  <= '0';
	LAN_TxD   <= (others => '0');
	LAN_MDC   <= '0';
	LAN_MDIO  <= 'Z';

	-- ***** IDE gp ***** --
	IDE_nRST  <= '1';
	IDE_nDIOR <= '1';
	IDE_nDIOW <= '1';
	IDE_DMACK <= '1';
	IDE_nCS   <= (others => '1');
	IDE_DA    <= (others => '0');
	IDE_DD    <= (others => 'Z');
	IDE_DIR   <= '1';

	-- ***** USB gp ***** --
	USB1_Dp     <= 'Z';
	USB1_Dn     <= 'Z';
	USB2_Dp     <= 'Z';
	USB2_Dn     <= 'Z';
	USB3_Dp     <= 'Z';
	USB3_Dn     <= 'Z';
	USB3_DISCON <= '0';

	-- ***** PS/2 gp ***** --
	PS2a_CLK  <= 'Z';
	PS2a_DATA <= 'Z';
	PS2b_CLK  <= 'Z';
	PS2b_DATA <= 'Z';

	-- ***** COM gp ***** --
	COM1_TxD <= '1';
	COM1_RTS <= '1';

end architecture RTL;
