
------------------------------------------------------------------------------
-- Title       : yuv2rgb.vhd
-- Description : YUV -> RGB ϊ
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 11/30/2007
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity YUV2RGB is
	port(
		CLK : in std_logic;
		YDI : in std_logic_vector(7 downto 0);
		UDI : in std_logic_vector(7 downto 0);
		VDI : in std_logic_vector(7 downto 0);
		RDO : out std_logic_vector(7 downto 0);
		GDO : out std_logic_vector(7 downto 0);
		BDO : out std_logic_vector(7 downto 0);
		HSI : in std_logic;
		VSI : in std_logic;
		BLI : in std_logic;
		HSO : out std_logic;
		VSO : out std_logic;
		BLO : out std_logic
	);
end YUV2RGB;

architecture RTL of YUV2RGB is
	type DEF_ROM is array (0 to 255) of integer range 0 to 511;
	constant RV : DEF_ROM :=
	(
		333, 334, 336, 337, 339, 340, 341, 343,
		344, 346, 347, 348, 350, 351, 353, 354,
		355, 357, 358, 360, 361, 362, 364, 365,
		367, 368, 369, 371, 372, 374, 375, 377,
		378, 379, 381, 382, 384, 385, 386, 388,
		389, 391, 392, 393, 395, 396, 398, 399,
		400, 402, 403, 405, 406, 407, 409, 410,
		412, 413, 414, 416, 417, 419, 420, 421,
		423, 424, 426, 427, 428, 430, 431, 433,
		434, 435, 437, 438, 440, 441, 442, 444,
		445, 447, 448, 449, 451, 452, 454, 455,
		456, 458, 459, 461, 462, 463, 465, 466,
		468, 469, 470, 472, 473, 475, 476, 477,
		479, 480, 482, 483, 484, 486, 487, 489,
		490, 491, 493, 494, 496, 497, 498, 500,
		501, 503, 504, 505, 507, 508, 510, 511,
		  0,   1,   2,   4,   5,   7,   8,   9,
		 11,  12,  14,  15,  16,  18,  19,  21,
		 22,  23,  25,  26,  28,  29,  30,  32,
		 33,  35,  36,  37,  39,  40,  42,  43,
		 44,  46,  47,  49,  50,  51,  53,  54,
		 56,  57,  58,  60,  61,  63,  64,  65,
		 67,  68,  70,  71,  72,  74,  75,  77,
		 78,  79,  81,  82,  84,  85,  86,  88,
		 89,  91,  92,  93,  95,  96,  98,  99,
		100, 102, 103, 105, 106, 107, 109, 110,
		112, 113, 114, 116, 117, 119, 120, 121,
		123, 124, 126, 127, 128, 130, 131, 133,
		134, 135, 137, 138, 140, 141, 143, 144,
		145, 147, 148, 150, 151, 152, 154, 155,
		157, 158, 159, 161, 162, 164, 165, 166,
		168, 169, 171, 172, 173, 175, 176, 178
	);
	constant GU : DEF_ROM :=
	(
		 44,  43,  43,  42,  42,  42,  41,  41,
		 41,  40,  40,  40,  39,  39,  39,  38,
		 38,  38,  37,  37,  37,  36,  36,  36,
		 35,  35,  35,  34,  34,  34,  33,  33,
		 33,  32,  32,  31,  31,  31,  30,  30,
		 30,  29,  29,  29,  28,  28,  28,  27,
		 27,  27,  26,  26,  26,  25,  25,  25,
		 24,  24,  24,  23,  23,  23,  22,  22,
		 22,  21,  21,  20,  20,  20,  19,  19,
		 19,  18,  18,  18,  17,  17,  17,  16,
		 16,  16,  15,  15,  15,  14,  14,  14,
		 13,  13,  13,  12,  12,  12,  11,  11,
		 11,  10,  10,   9,   9,   9,   8,   8,
		  8,   7,   7,   7,   6,   6,   6,   5,
		  5,   5,   4,   4,   4,   3,   3,   3,
		  2,   2,   2,   1,   1,   1,   0,   0,
		  0,   0,   0, 511, 511, 511, 510, 510,
		510, 509, 509, 509, 508, 508, 508, 507,
		507, 507, 506, 506, 506, 505, 505, 505,
		504, 504, 504, 503, 503, 503, 502, 502,
		501, 501, 501, 500, 500, 500, 499, 499,
		499, 498, 498, 498, 497, 497, 497, 496,
		496, 496, 495, 495, 495, 494, 494, 494,
		493, 493, 493, 492, 492, 492, 491, 491,
		490, 490, 490, 489, 489, 489, 488, 488,
		488, 487, 487, 487, 486, 486, 486, 485,
		485, 485, 484, 484, 484, 483, 483, 483,
		482, 482, 482, 481, 481, 481, 480, 480,
		479, 479, 479, 478, 478, 478, 477, 477,
		477, 476, 476, 476, 475, 475, 475, 474,
		474, 474, 473, 473, 473, 472, 472, 472,
		471, 471, 471, 470, 470, 470, 469, 469
	);
	constant GV : DEF_ROM :=
	(
		 91,  90,  89,  89,  88,  87,  87,  86,
		 85,  84,  84,  83,  82,  82,  81,  80,
		 79,  79,  78,  77,  77,  76,  75,  74,
		 74,  73,  72,  72,  71,  70,  69,  69,
		 68,  67,  67,  66,  65,  64,  64,  63,
		 62,  62,  61,  60,  59,  59,  58,  57,
		 57,  56,  55,  54,  54,  53,  52,  52,
		 51,  50,  49,  49,  48,  47,  47,  46,
		 45,  44,  44,  43,  42,  42,  41,  40,
		 39,  39,  38,  37,  37,  36,  35,  34,
		 34,  33,  32,  32,  31,  30,  29,  29,
		 28,  27,  27,  26,  25,  24,  24,  23,
		 22,  22,  21,  20,  19,  19,  18,  17,
		 17,  16,  15,  14,  14,  13,  12,  12,
		 11,  10,   9,   9,   8,   7,   7,   6,
		  5,   4,   4,   3,   2,   2,   1,   0,
		  0,   0, 511, 510, 510, 509, 508, 508,
		507, 506, 505, 505, 504, 503, 503, 502,
		501, 500, 500, 499, 498, 498, 497, 496,
		495, 495, 494, 493, 493, 492, 491, 490,
		490, 489, 488, 488, 487, 486, 485, 485,
		484, 483, 483, 482, 481, 480, 480, 479,
		478, 478, 477, 476, 475, 475, 474, 473,
		473, 472, 471, 470, 470, 469, 468, 468,
		467, 466, 465, 465, 464, 463, 463, 462,
		461, 460, 460, 459, 458, 458, 457, 456,
		455, 455, 454, 453, 453, 452, 451, 450,
		450, 449, 448, 448, 447, 446, 445, 445,
		444, 443, 443, 442, 441, 440, 440, 439,
		438, 438, 437, 436, 435, 435, 434, 433,
		433, 432, 431, 430, 430, 429, 428, 428,
		427, 426, 425, 425, 424, 423, 423, 422
	);
	constant BU : DEF_ROM :=
	(
		286, 287, 289, 291, 293, 295, 296, 298,
		300, 302, 303, 305, 307, 309, 310, 312,
		314, 316, 318, 319, 321, 323, 325, 326,
		328, 330, 332, 334, 335, 337, 339, 341,
		342, 344, 346, 348, 349, 351, 353, 355,
		357, 358, 360, 362, 364, 365, 367, 369,
		371, 373, 374, 376, 378, 380, 381, 383,
		385, 387, 388, 390, 392, 394, 396, 397,
		399, 401, 403, 404, 406, 408, 410, 411,
		413, 415, 417, 419, 420, 422, 424, 426,
		427, 429, 431, 433, 435, 436, 438, 440,
		442, 443, 445, 447, 449, 450, 452, 454,
		456, 458, 459, 461, 463, 465, 466, 468,
		470, 472, 474, 475, 477, 479, 481, 482,
		484, 486, 488, 489, 491, 493, 495, 497,
		498, 500, 502, 504, 505, 507, 509, 511,
		  0,   1,   3,   5,   7,   8,  10,  12,
		 14,  15,  17,  19,  21,  23,  24,  26,
		 28,  30,  31,  33,  35,  37,  38,  40,
		 42,  44,  46,  47,  49,  51,  53,  54,
		 56,  58,  60,  62,  63,  65,  67,  69,
		 70,  72,  74,  76,  77,  79,  81,  83,
		 85,  86,  88,  90,  92,  93,  95,  97,
		 99, 101, 102, 104, 106, 108, 109, 111,
		113, 115, 116, 118, 120, 122, 124, 125,
		127, 129, 131, 132, 134, 136, 138, 139,
		141, 143, 145, 147, 148, 150, 152, 154,
		155, 157, 159, 161, 163, 164, 166, 168,
		170, 171, 173, 175, 177, 178, 180, 182,
		184, 186, 187, 189, 191, 193, 194, 196,
		198, 200, 202, 203, 205, 207, 209, 210,
		212, 214, 216, 217, 219, 221, 223, 225
	);
	
	signal TRY : std_logic_vector(8 downto 0);
	signal TGY : std_logic_vector(8 downto 0);
	signal TBY : std_logic_vector(8 downto 0);
	signal TRU : std_logic_vector(8 downto 0);
	signal TGU : std_logic_vector(8 downto 0);
	signal TBU : std_logic_vector(8 downto 0);
	signal TRV : std_logic_vector(8 downto 0);
	signal TGV : std_logic_vector(8 downto 0);
	signal TBV : std_logic_vector(8 downto 0);
	
	signal TR  : std_logic_vector(9 downto 0);
	signal TG  : std_logic_vector(9 downto 0);
	signal TB  : std_logic_vector(9 downto 0);

	signal HSD : std_logic_vector(2 downto 1);
	signal VSD : std_logic_vector(2 downto 1);
	signal BLD : std_logic_vector(2 downto 1);
begin
-- YUV -> R ϊ ( r = y + 1.402*(v - 128) )
	process(CLK) begin
		if (CLK'event and CLK = '1') then
 			TRY <= '0' & YDI;
			TRV <= conv_std_logic_vector(RV(conv_integer(VDI)), 9);
			
			TR  <= (TRY(8) & TRY) + (TRV(8) & TRV);
			
			if(TR(9 downto 8) = "00") then
				RDO <= TR(7 downto 0);
			elsif(TR(9 downto 8) = "01") then
				RDO <= "11111111";
			else
				RDO <= "00000000";
			end if;
		end if;
	end process;

-- YUV -> G ϊ ( g = y - 0.344*(u - 128) - 0.714*(v - 128) )
	process(CLK) begin
		if (CLK'event and CLK = '1') then
 			TGY <= '0' & YDI;
			TGU <= conv_std_logic_vector(GU(conv_integer(UDI)), 9);
			TGV <= conv_std_logic_vector(GV(conv_integer(VDI)), 9);
			
			TG  <= (TGY(8) & TGY) + (TGU(8) & TGU) + (TGV(8) & TGV);
			
			if(TG(9 downto 8) = "00") then
				GDO <= TG(7 downto 0);
			elsif(TG(9 downto 8) = "01") then
				GDO <= "11111111";
			else
				GDO <= "00000000";
			end if;
		end if;
	end process;

-- YUV -> B ϊ ( b = y + 1.772*(u - 128) )
	process(CLK) begin
		if (CLK'event and CLK = '1') then
 			TBY <= '0' & YDI;
			TBU <= conv_std_logic_vector(BU(conv_integer(UDI)), 9);
			
			TB  <= (TBY(8) & TBY) + (TBU(8) & TBU);
			
			if(TB(9 downto 8) = "00") then
				BDO <= TB(7 downto 0);
			elsif(TB(9 downto 8) = "01") then
				BDO <= "11111111";
			else
				BDO <= "00000000";
			end if;
		end if;
	end process;

-- 摜f[^Ƃ̒x
	process(CLK) begin
		if (CLK'event and CLK = '1') then
			HSD(1) <= HSI;
			HSD(2) <= HSD(1);
			HSO    <= HSD(2);
			
			VSD(1) <= VSI;
			VSD(2) <= VSD(1);
			VSO    <= VSD(2);
			
			BLD(1) <= BLI;
			BLD(2) <= BLD(1);
			BLO    <= BLD(2);
		end if;
	end process;
end RTL;
