
------------------------------------------------------------------------------
-- Title       : system_stub.vhd
-- Description : BLANCA MEDIA Processor for E!Kit-CAM-TTL
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 08/31/2007
------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity SYSTEM_STUB is
	port (

	-- VXeZbg/NMIMs
		SYS_nRST    : in std_logic;								-- Zbg
		SYS_nNMI    : in std_logic;								-- NMI
		SYS_nRESETo : out std_logic;							-- Zbgo(I/OvZbT)

	-- [U[gpNbN̓s
		USER_CLK : in std_logic;								-- gp

	-- [JoXMs
		L_CLK    : in std_logic;								-- NbN
		L_nCS    : out std_logic_vector( 7 downto 0);			-- `bvZNgo
		L_nROMCS : in std_logic;								-- ROM`bvZNg
		L_A      : out std_logic_vector(28 downto 0);			-- AhXoXo
		L_nBE    : out std_logic_vector( 3 downto 0);			-- oCgCl[uo
		L_nRD    : out std_logic;								-- [ho
		L_nWR    : out std_logic;								-- Cgo
		L_RnW    : out std_logic;								-- [h/Cgo
		L_D      : inout std_logic_vector(31 downto 0);			-- f[^oX
		L_nWAIT  : in std_logic;								-- EFCg

	-- I/OvZbT荞ݓ
		IOP_nINT : inout std_logic_vector(15 downto 0);			-- I/OvZbT荞ݓ(_)

	-- PCIoXMs
		PCI_CLK     : in std_logic;								-- PCIoXNbN
		PCI_AD      : inout std_logic_vector(31 downto 0);		-- AhX/f[^oX
		PCI_CnBE    : inout std_logic_vector( 3 downto 0);		-- PCIoXR}h/oCgCl[u
		PCI_nFRAME  : inout std_logic;							-- t[
		PCI_nIRDY   : inout std_logic;							-- CjVG[^fB
		PCI_nDEVSEL : inout std_logic;							-- foCXZNV
		PCI_nTRDY   : inout std_logic;							-- ^[QbgfB
		PCI_nSTOP   : inout std_logic;							-- ]Xgbvv
		PCI_PAR     : inout std_logic;							-- peBrbg(o͂̂)
		PCI_nPERR   : inout std_logic;							-- peBG[
		PCI_nSERR   : inout std_logic;							-- VXeG[
		PCI_nINTA   : inout std_logic;							-- 荞ݏo INTA#
		PCI_nINTB   : inout std_logic;							-- 荞ݏo INTB#
		PCI_nINTC   : inout std_logic;							-- 荞ݏo INTC#
		PCI_nINTD   : inout std_logic;							-- 荞ݏo INTD#
	-- PCIoX(Zg\[X)Ms
		PCI_nRST    : out std_logic;							-- PCIoXZbgo
		PCI_nREQ    : in std_logic_vector( 3 downto 0);			-- oXgpvM
		PCI_nGNT    : out std_logic_vector( 3 downto 0);		-- oXgpMo
		PCI_M66EN   : in std_logic;								-- 66MHz PCI[h
		PCI_XCAP    : in std_logic;								-- PCI-X[h

	-- AiORGBMs
		V_F48M   : in std_logic;								-- rfINbN1
		V_F25M   : in std_logic;								-- rfINbN2
		V_CLK    : out std_logic;								-- rfINbNo
		V_nBLANK : out std_logic;								-- uLO
		V_nHSYNC : out std_logic;								-- 
		V_nVSYNC : out std_logic;								-- 
		V_R      : out std_logic_vector( 7 downto 0);			-- 
		V_G      : out std_logic_vector( 7 downto 0);			-- 
		V_B      : out std_logic_vector( 7 downto 0);			-- 

	-- AC97R[fbNMs
		AC97_nRST : out std_logic;								-- Zbg
		AC97_SCLK : in std_logic;								-- NbN
		AC97_SYNC : out std_logic;								-- 
		AC97_SDO  : out std_logic;								-- f[^o
		AC97_SDI  : in std_logic;								-- f[^

	-- tbVROMMs(m[})
		ROM_nCE   : out std_logic;								-- `bvCl[u
		ROM_nOE   : out std_logic;								-- AEgvbgCl[u
		ROM_nWE   : out std_logic;								-- CgCl[u
		ROM_nBYTE : out std_logic;								-- oCgZNg
		ROM_A     : out std_logic_vector(23 downto 1);			-- AhXoX
		ROM_D     : inout std_logic_vector(15 downto 0);		-- f[^oX

	-- SDRAMMs
		SD_CLK  : out std_logic;								-- SDRAM쓮ONbN
		SD_CKE  : out std_logic;								-- NbNCl[u
		SD_nCS  : out std_logic;								-- `bvZNg
		SD_nRAS : out std_logic;								-- /RAS
		SD_nCAS : out std_logic;								-- /CAS
		SD_nWE  : out std_logic;								-- CgCl[u
		SD_DQM  : out std_logic_vector( 3 downto 0);			-- oCgCl[u
		SD_MBA  : out std_logic_vector( 1 downto 0);			-- oNAhX
		SD_MA   : out std_logic_vector(11 downto 0);			-- AhXoX
		SD_MD   : inout std_logic_vector(31 downto 0);			-- f[^oX

	-- MMCJ[hMs
		MMC_CLK   : out std_logic;								-- NbN
		MMC_nCS   : out std_logic;								-- `bvZNg
		MMC_DIN   : out std_logic;								-- J[hf[^
		MMC_DOUT  : in std_logic;								-- J[hf[^o
		MMC_nCD1  : in std_logic;								-- J[hfBeNg1
		MMC_nCD2  : in std_logic;								-- J[hfBeNg2
		MMC_DATA1 : out std_logic;								-- f[^oX1
		MMC_DATA2 : out std_logic;								-- f[^oX2
		MMC_nWP   : in std_logic;								-- CgveNg

	-- COM|[gMs
		COM2_TxD : out std_logic;								-- TxD
		COM2_RxD : in std_logic;								-- RxD
		COM2_RTS : out std_logic;								-- RTS
		COM2_CTS : in std_logic;								-- CTS
		COMx_EN  : out std_logic;								-- VAhCoCl[u

	-- fBbvXCb`/LEDMs
		AVP_LED   : out std_logic_vector( 3 downto 0);			-- fBbvXCb`
		AVP_DIPSW : in std_logic_vector( 3 downto 0)			-- LED

  );
end SYSTEM_STUB;

architecture RTL of SYSTEM_STUB is

	component CAM_SYS
	port (

		RST : in std_logic;

	-- SDRAMM
		MEM_CLK : in std_logic;
		SD_LOCK : in std_logic;
		SD_CKE  : out std_logic;
		SD_CS   : out std_logic;
		SD_RAS  : out std_logic;
		SD_CAS  : out std_logic;
		SD_WE   : out std_logic;
		SD_DQM  : out std_logic_vector( 3 downto 0);
		SD_MBA  : out std_logic_vector( 1 downto 0);
		SD_MA   : out std_logic_vector(11 downto 0);
		SD_MD_i : in std_logic_vector(31 downto 0);
		SD_MD_o : out std_logic_vector(31 downto 0);
		SD_MD_t : out std_logic;

	-- AiORGBM
		CRT_CLK : in std_logic;
		V_BLANK : out std_logic;
		V_HSYNC : out std_logic;
		V_VSYNC : out std_logic;
		V_R     : out std_logic_vector( 7 downto 0);
		V_G     : out std_logic_vector( 7 downto 0);
		V_B     : out std_logic_vector( 7 downto 0);

	-- COM|[gM
		COM2_TxD : out std_logic;
		COM2_RxD : in std_logic;

	-- LEDM/fBbvXCb`/NMIXCb`
		LED : out std_logic_vector(3 downto 0);
		SW  : in std_logic_vector(3 downto 0);
		NMI : in std_logic;

	-- AVP/IOPԐM
		PIXCLK  : in std_logic;
		FRAME   : in std_logic;
		LINE    : in std_logic;
		DOUT    : in std_logic_vector(7 downto 0);
		SCL_IN  : in std_logic;
		SCL_OUT : out std_logic;
		SDA_IN  : in std_logic;
		SDA_OUT : out std_logic
	);
	end component;

	signal RST : std_logic;

	signal V_F48M_IBUFG  : std_logic;
	signal V_F48M_CLK0   : std_logic;
	signal V_F48M_CLK3   : std_logic;
	signal V_F48M_LOCKED : std_logic;
	signal MEM_CLK       : std_logic;

	signal V_F25M_IBUFG  : std_logic;
	signal V_F25M_CLK0   : std_logic;
	signal V_F25M_CLK2   : std_logic;
	signal V_F25M_LOCKED : std_logic;
	signal CRT_CLK       : std_logic;

	signal L_CLK_IBUFG  : std_logic;
	signal L_CLK_LOCKED : std_logic;
	signal CAM_CLK      : std_logic;

	signal SD_CS   : std_logic;
	signal SD_RAS  : std_logic;
	signal SD_CAS  : std_logic;
	signal SD_WE   : std_logic;
	signal SD_MD_i : std_logic_vector(31 downto 0);
	signal SD_MD_o : std_logic_vector(31 downto 0);
	signal SD_MD_t : std_logic;

	signal V_HSYNC : std_logic;
	signal V_VSYNC : std_logic;

	signal LED : std_logic_vector(3 downto 0);

begin

	U_IBUFG_48M : IBUFG port map(
		I => V_F48M,
		O => V_F48M_IBUFG
	);

	U_BUFG_48M : BUFG port map(
		I => V_F48M_CLK0,
		O => MEM_CLK
	);

	U_DCM_48M : DCM
	generic map (
		CLK_FEEDBACK => "1X",
		CLKDV_DIVIDE => 2.0,
		CLKFX_DIVIDE => 1,
		CLKFX_MULTIPLY => 3,
		CLKIN_DIVIDE_BY_2 => false,
		CLKIN_PERIOD => 20.0,
		CLKOUT_PHASE_SHIFT => "NONE",
		DESKEW_ADJUST => "SYSTEM_SYNCHRONOUS",
		DFS_FREQUENCY_MODE => "LOW",
		DLL_FREQUENCY_MODE => "LOW",
		DUTY_CYCLE_CORRECTION => true,
		PHASE_SHIFT => 0,
		STARTUP_WAIT => false
	)
	port map (
		CLKIN    => V_F48M_IBUFG,
		CLKFB    => MEM_CLK,
		RST      => not SYS_nRST,
		PSEN     => '0',
		PSINCDEC => '0',
		PSCLK    => '0',
		DSSEN    => '0',
		CLK0     => V_F48M_CLK0,
		CLK90    => open,
		CLK180   => open,
		CLK270   => V_F48M_CLK3,
		CLKDV    => open,
		CLK2X    => open,
		CLK2X180 => open,
		CLKFX    => open,
		CLKFX180 => open,
		STATUS   => open,
		LOCKED   => V_F48M_LOCKED,
		PSDONE   => open
	);

	U_IBUFG_25M : IBUFG port map(
		I => V_F25M,
		O => V_F25M_IBUFG
	);

	U_BUFG_25M : BUFG port map(
		I => V_F25M_CLK0,
		O => CRT_CLK
	);

	U_DCM_25M : DCM
	generic map (
		CLK_FEEDBACK => "1X",
		CLKDV_DIVIDE => 2.0,
		CLKFX_DIVIDE => 1,
		CLKFX_MULTIPLY => 3,
		CLKIN_DIVIDE_BY_2 => false,
		CLKIN_PERIOD => 40.0,
		CLKOUT_PHASE_SHIFT => "NONE",
		DESKEW_ADJUST => "SYSTEM_SYNCHRONOUS",
		DFS_FREQUENCY_MODE => "LOW",
		DLL_FREQUENCY_MODE => "LOW",
		DUTY_CYCLE_CORRECTION => true,
		PHASE_SHIFT => 0,
		STARTUP_WAIT => false
	)
	port map (
		CLKIN    => V_F25M_IBUFG,
		CLKFB    => CRT_CLK,
		RST      => not SYS_nRST,
		PSEN     => '0',
		PSINCDEC => '0',
		PSCLK    => '0',
		DSSEN    => '0',
		CLK0     => V_F25M_CLK0,
		CLK90    => open,
		CLK180   => V_F25M_CLK2,
		CLK270   => open,
		CLKDV    => open,
		CLK2X    => open,
		CLK2X180 => open,
		CLKFX    => open,
		CLKFX180 => open,
		STATUS   => open,
		LOCKED   => V_F25M_LOCKED,
		PSDONE   => open
	);

	U_IBUFG_L : IBUFG port map(
		I => L_CLK,
		O => L_CLK_IBUFG
	);

	U_BUFG_L : BUFG port map(
		I => L_CLK_IBUFG,
		O => CAM_CLK
	);

	L_CLK_LOCKED <= IOP_nINT(0);

	-- ***** ZbgM ***** --
	RST <= (not SYS_nRST)
			or (not V_F48M_LOCKED)
			or (not V_F25M_LOCKED)
			or (not L_CLK_LOCKED);

	U_CAM_SYS : CAM_SYS
	port map(

		RST => RST,

	-- SDRAMM
		MEM_CLK => MEM_CLK,
		SD_LOCK => not RST,
		SD_CKE  => SD_CKE,
		SD_CS   => SD_CS,
		SD_RAS  => SD_RAS,
		SD_CAS  => SD_CAS,
		SD_WE   => SD_WE,
		SD_DQM  => SD_DQM,
		SD_MBA  => SD_MBA,
		SD_MA   => SD_MA,
		SD_MD_i => SD_MD_i,
		SD_MD_o => SD_MD_o,
		SD_MD_t => SD_MD_t,

	-- AiORGBM
		CRT_CLK => CRT_CLK,
		V_BLANK => V_nBLANK,
		V_HSYNC => V_HSYNC,
		V_VSYNC => V_VSYNC,
		V_R     => V_R,
		V_G     => V_G,
		V_B     => V_B,

	-- COM|[gM
		COM2_TxD => COM2_TxD,
		COM2_RxD => COM2_RxD,

	-- LEDM/fBbvXCb`/NMIXCb`
		LED => LED,
		SW  => not AVP_DIPSW,
		NMI => not SYS_nNMI,

	-- AVP/IOPԐM
		PIXCLK  => CAM_CLK,
		FRAME   => IOP_nINT(2),
		LINE    => IOP_nINT(3),
		DOUT    => L_D(23 downto 16),
		SCL_IN  => IOP_nINT(5),
		SCL_OUT => IOP_nINT(4),
		SDA_IN  => IOP_nINT(7),
		SDA_OUT => IOP_nINT(6)
	);

	-- ***** SDRAM ڑ ***** --
	SD_CLK  <= V_F48M_CLK3;
	SD_nCS  <= not SD_CS;
	SD_nRAS <= not SD_RAS;
	SD_nCAS <= not SD_CAS;
	SD_nWE  <= not SD_WE;
	SD_MD   <= SD_MD_o when (SD_MD_t = '1') else (others => 'Z');
	SD_MD_i <= SD_MD;

	-- ***** AiORGB ڑ ***** --
	V_CLK    <= V_F25M_CLK2;
	V_nHSYNC <= not V_HSYNC;
	V_nVSYNC <= not V_VSYNC;

	-- ***** LED ڑ ***** --
	AVP_LED <= not LED;

	-- ***** VXeZbg gp ***** --
	SYS_nRESETo <= '1';

	-- ***** [JoXf[^oX gp ***** --
	L_nCS <= (others => '1');
	L_A   <= (others => '0');
	L_nBE <= (others => '1');
	L_nRD <= '1';
	L_nWR <= '1';
	L_RnW <= '1';
	L_D(15 downto 0)  <= (others => 'Z');
	L_D(31 downto 24) <= (others => 'Z');

	-- ***** PCIoX gp ***** --
	PCI_AD      <= (others => 'Z');
	PCI_CnBE    <= (others => 'Z');
	PCI_nFRAME  <= 'Z';
	PCI_nIRDY   <= 'Z';
	PCI_nDEVSEL <= 'Z';
	PCI_nTRDY   <= 'Z';
	PCI_nSTOP   <= 'Z';
	PCI_PAR     <= 'Z';
	PCI_nPERR   <= 'Z';
	PCI_nSERR   <= 'Z';
	PCI_nINTA   <= 'Z';
	PCI_nINTB   <= 'Z';
	PCI_nINTC   <= 'Z';
	PCI_nINTD   <= 'Z';
	PCI_nRST    <= '1';
	PCI_nGNT    <= (others => '1');

	-- ***** AC97R[fbN gp ***** --
	AC97_nRST <= '1';
	AC97_SYNC <= '0';
	AC97_SDO  <= '0';

	-- ***** FlashROMf[^oX gp ***** --
	ROM_nCE   <= '1';
	ROM_nOE   <= '1';
	ROM_nWE   <= '1';
	ROM_nBYTE <= '1';
	ROM_A     <= (others => '0');
	ROM_D     <= (others => 'Z');

	-- ***** MMC gp ***** --
	MMC_CLK   <= '1';
	MMC_nCS   <= '1';
	MMC_DIN   <= '0';
	MMC_DATA1 <= '0';
	MMC_DATA2 <= '0';

	-- ***** COM|[g gp ***** --
	COM2_RTS <= '1';
	COMx_EN  <= '0';

end architecture RTL;
