
------------------------------------------------------------------------------
-- Title       : i2c.vhd
-- Description : I2C
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 08/31/2007
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity I2C is
	port (
		RST          : in std_logic;
		CLK          : in std_logic;
		EN_5_X_BAUD  : in std_logic;
		SCL_OUT      : out std_logic;
		SCL_IN       : in std_logic;
		SDA_OUT      : out std_logic;
		SDA_IN       : in std_logic;
		DATA_OUT     : out std_logic_vector(7 downto 0);
		ACK_OUT      : out std_logic;
		DATA_PRESENT : out std_logic;
		DATA_IN      : in std_logic_vector(7 downto 0);
		ACK_IN       : in std_logic;
		WRITE_STROBE : in std_logic;
		START        : in std_logic;
		STOP         : in std_logic
	);
end I2C;

architecture RTL of I2C is

	signal STATE_CNT : integer range 0 to 11;
	signal STEP_CNT  : integer range 0 to 3;
	
	signal SCL     : std_logic;
	signal SDA     : std_logic;
	signal SCL_S   : std_logic_vector(1 downto 0);
	
	signal DATA : std_logic_vector(7 downto 0);

begin

	SCL_OUT <= SCL;
	SDA_OUT <= SDA;

	process(CLK) begin
		if (CLK'event and CLK = '1') then
			SCL_S(0) <= SCL_IN;
			SCL_S(1) <= SCL_S(0);
		end if;
	end process;

	process(CLK) begin
		if (CLK'event and CLK = '1') then
			if (WRITE_STROBE = '1') then
				DATA <= DATA_IN;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (RST = '1') then
			STEP_CNT <= 0;
		elsif (CLK'event and CLK = '1') then
			if (EN_5_X_BAUD = '1') then
				if (STATE_CNT /= 0) then
					if (STEP_CNT = 0) then
						STEP_CNT <= STEP_CNT + 1;
					elsif (STEP_CNT = 1) then
						STEP_CNT <= STEP_CNT + 1;
					elsif ((STEP_CNT = 2) and (SCL_S(1) = '1')) then
						STEP_CNT <= STEP_CNT + 1;
					elsif (STEP_CNT = 3) then
						STEP_CNT <= 0;
					end if;
				else
					STEP_CNT <= 0;
				end if;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (RST = '1') then
			STATE_CNT <= 0;
		elsif (CLK'event and CLK = '1') then
			if (WRITE_STROBE = '1') then
				if (START = '0') then
					STATE_CNT <= 2;
				else
					STATE_CNT <= 1;
				end if;
			elsif (EN_5_X_BAUD = '1') then
				if (STEP_CNT = 3) then
					if (STOP = '0' and STATE_CNT = 10) then
						STATE_CNT <= 0;
					elsif (STATE_CNT = 11) then
						STATE_CNT <= 0;
					else
						STATE_CNT <= STATE_CNT + 1;
					end if;
				end if;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (RST = '1') then
			SCL <= '1';
		elsif (CLK'event and CLK = '1') then
			if (EN_5_X_BAUD = '1') then
				if (STATE_CNT /= 0) then
					if (STEP_CNT = 0) then
						SCL <= '0';
					elsif (STEP_CNT = 2) then
						SCL <= '1';
					end if;
				end if;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (RST = '1') then
			SDA <= '1';
		elsif (CLK'event and CLK = '1') then
			if (EN_5_X_BAUD = '1') then
				if (STATE_CNT = 1) then
					if(STEP_CNT = 1) then
						SDA <= '1';
					elsif(STEP_CNT = 3) then
						SDA <= '0';
					end if;
				elsif (STATE_CNT = 11) then
					if(STEP_CNT = 1) then
						SDA <= '0';
					elsif(STEP_CNT = 3) then
						SDA <= '1';
					end if;
				elsif (STATE_CNT = 10) then
					if (STEP_CNT = 1) then
						SDA <= ACK_IN;
					elsif (STEP_CNT = 3) then
						ACK_OUT <= SDA_IN;
					end if;
				else
					if (STEP_CNT = 1) then
						SDA <= DATA(9 - STATE_CNT);
					elsif (STEP_CNT = 3) then
						DATA_OUT(9 - STATE_CNT) <= SDA_IN;
					end if;
				end if;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (RST = '1') then
			DATA_PRESENT <= '0';
		elsif (CLK'event and CLK = '1') then
			if (WRITE_STROBE = '1') then
				DATA_PRESENT <= '0';
			elsif ((EN_5_X_BAUD = '1') and (STEP_CNT = 3)) then
				if ((STOP = '0') and (STATE_CNT = 10)) then
					DATA_PRESENT <= '1';
				elsif (STATE_CNT = 11) then
					DATA_PRESENT <= '1';
				end if;
			end if;
		end if;
	end process;

end RTL;
