
------------------------------------------------------------------------------
-- Title       : crtc.vhd
-- Description : \Rg[
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 09/04/2007
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity CRTC is
	generic (
		BUFLEN : integer := 32
	);
	port (
		RST    : in std_logic;
		CLK    : in std_logic;
		HSYN   : out std_logic;
		VSYN   : out std_logic;
		BLNK   : out std_logic;
		BUFADR : out integer range 0 to BUFLEN - 1;
		BUFCLR : out std_logic;
		BDI    : in std_logic_vector(31 downto 0);
		YDO    : out std_logic_vector(7 downto 0);
		UDO    : out std_logic_vector(7 downto 0);
		VDO    : out std_logic_vector(7 downto 0)
	);
end CRTC;

architecture RTL of CRTC is
	signal LCNT : integer range 0 to 799;
	signal FCNT : integer range 0 to 524;
	signal XCNT : integer range 0 to 1;
	signal HS   : std_logic;
	signal VS   : std_logic;
	signal HD   : std_logic;
	signal VD   : std_logic;
	signal ADR  : integer range 0 to BUFLEN - 1;
	signal CLR  : std_logic;
begin

-- JE^
	process(CLK, RST) begin
		if (RST = '1') then
			LCNT <= 0;
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 799) then
				LCNT <= 0;
			else
				LCNT <= LCNT + 1;
			end if;
		end if;
	end process;

-- \
	process(CLK, RST) begin
		if (RST = '1') then
			HD <= '0';
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 0) then
				HD <= '1';
			elsif (LCNT = 640) then
				HD <= '0';
			end if;
		end if;
	end process;

-- 
	process(CLK, RST) begin
		if (RST = '1') then
			HS <= '0';
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 664) then
				HS <= '1';
			elsif (LCNT = 760) then
				HS <= '0';
			end if;
		end if;
	end process;

-- JE^
	process(CLK, RST) begin
		if (RST = '1') then
			FCNT <= 0;
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 799) then
				if (FCNT = 524) then
					FCNT <= 0;
				else
					FCNT <= FCNT + 1;
				end if;
			end if;
		end if;
	end process;

-- \
	process(CLK, RST) begin
		if (RST = '1') then
			VD <= '0';
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 0) then
				if (FCNT = 0) then
					VD <= '1';
				elsif (FCNT = 480) then
					VD <= '0';
				end if;
			end if;
		end if;
	end process;

-- 
	process(CLK, RST) begin
		if (RST = '1') then
			VS <= '0';
		elsif (CLK'event and CLK = '1') then
			if (LCNT = 0) then
				if (FCNT = 491) then
					VS <= '1';
				elsif (FCNT = 493) then
					VS <= '0';
				end if;
			end if;
		end if;
	end process;

-- \pobt@E[h
	process(CLK, RST) begin
		if (RST = '1') then
			XCNT <= 0;
			ADR  <= 0;
			CLR  <= '0';
		elsif (CLK'event and CLK = '1') then
			if (VS = '1') then
				XCNT <= 0;
				ADR  <= 0;
				CLR  <= '0';
			else
				if (HD = '1' and VD = '1') then
					if(XCNT = 1) then
						XCNT <= 0;
						
						if(ADR = BUFLEN / 2 - 1) then
							ADR <= ADR + 1;
							CLR <= '1';
						elsif(ADR = BUFLEN - 1) then
							ADR <= 0;
							CLR <= '0';
						else
							ADR <= ADR + 1;
						end if;
					else
						XCNT <= XCNT + 1;
					end if;
				end if;
			end if;
		end if;
	end process;

	process(CLK, RST) begin
		if (CLK'event and CLK = '1') then
			HSYN <= HS;
			VSYN <= VS;
			BLNK <= HD and VD;
		end if;
	end process;

	BUFADR <= ADR;
	BUFCLR <= CLR;

-- \f[^
	process(XCNT, BDI) begin
		if(XCNT = 0) then
			YDO <= BDI( 7 downto  0);			--  Y(i)
			UDO <= BDI(15 downto  8);			-- Cb(i)
			VDO <= BDI(31 downto 24);			-- Cr(i)
		else
			YDO <= BDI(23 downto 16);			--  Y(i+1)
			UDO <= BDI(15 downto  8);			-- Cb(i)
			VDO <= BDI(31 downto 24);			-- Cr(i)
		end if;
	end process;
end RTL;
