
------------------------------------------------------------------------------
-- Title       : camc.vhd
-- Description : JRg[
-- Author      : KAWAMOTO Yasuhisa
-- MAIL        : kawamoto@devdrv.co.jp
-- Date        : 08/31/2007
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity CAMC is
	generic (
		BUFLEN : integer := 32
	);
	port (
		RST    : in std_logic;
		CLK    : in std_logic;
		LIN    : in std_logic;
		FRM    : in std_logic;
		BUFADR : out integer range 0 to BUFLEN - 1;
		BUFWE  : out std_logic;
		BUFCLR : out std_logic;
		PDI    : in std_logic_vector(7 downto 0);
		BDO    : out std_logic_vector(31 downto 0)
	);
end CAMC;

architecture RTL of CAMC is
	signal XCNT : integer range 0 to 3;
	signal ADR  : integer range 0 to BUFLEN - 1;
	signal CLR  : std_logic;
	signal SFTD : std_logic_vector(31 downto 0);
begin

-- Jpobt@ECg
	process(CLK, RST) begin
		if (RST = '1') then
			XCNT <= 0;
			ADR  <= 0;
			CLR  <= '0';
		elsif (CLK'event and CLK = '1') then
			if (FRM = '0') then
				XCNT <= 0;
				ADR  <= 0;
				CLR  <= '0';
			else
				if (LIN = '1') then
					if (XCNT = 3) then
						XCNT <= 0;
						
						if(ADR = BUFLEN / 2 - 1) then
							ADR <= ADR + 1;
							CLR <= '1';
						elsif(ADR = BUFLEN - 1) then
							ADR <= 0;
							CLR <= '0';
						else
							ADR <= ADR + 1;
						end if;
					else
						XCNT <= XCNT + 1;
					end if;
				end if;
			end if;
		end if;
	end process;

	BUFADR <= ADR;
	BUFCLR <= CLR;

	process(XCNT) begin
		if (XCNT = 3) then
			BUFWE <= '1';
		else
			BUFWE <= '0';
		end if;
	end process;

-- Jf[^
-- f[^V[g(MT9M112_DS_features1.fm - Rev.B 12/05 EN)̎dl
--	process(PDI) begin
--		SFTD(23 downto 16) <= PDI;						-- Y(n+1)
--	end process;

--	process(CLK) begin
--		if (CLK'event and CLK = '1') then
--			SFTD(31 downto 24) <= SFTD(23 downto 16);	-- Cr(n)
--			SFTD(7 downto 0)   <= SFTD(31 downto 24);	-- Y(n)
--			SFTD(15 downto  8) <= SFTD(7 downto 0);		-- Cb(n)
--		end if;
--	end process;

-- ۂ̎dl?
	process(PDI) begin
		SFTD(7 downto 0) <= PDI;						-- Y(n)
	end process;

	process(CLK) begin
		if (CLK'event and CLK = '1') then
			SFTD(31 downto 24) <= SFTD( 7 downto  0);	-- Cr(n)
			SFTD(23 downto 16) <= SFTD(31 downto 24);	-- Y(n+1)
			SFTD(15 downto  8) <= SFTD(23 downto 16);	-- Cb(n)
		end if;
	end process;

	BDO <= SFTD;
end RTL;
