
------------------------------------------------------------------------------
-- Title       : CAM_SYS.VHD
-- Description : E!Kit-CAM-TTLW[
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 10/22/2007
------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity CAM_SYS is
	port (

		RST : in std_logic;
		CLK : in std_logic;

	-- SDRAMM
		MEM_CLK : in std_logic;
		SD_LOCK : in std_logic;
		SD_CKE  : out std_logic;
		SD_CS   : out std_logic;
		SD_RAS  : out std_logic;
		SD_CAS  : out std_logic;
		SD_WE   : out std_logic;
		SD_DQM  : out std_logic_vector( 3 downto 0);
		SD_MBA  : out std_logic_vector( 1 downto 0);
		SD_MA   : out std_logic_vector(11 downto 0);
		SD_MD_i : in std_logic_vector(31 downto 0);
		SD_MD_o : out std_logic_vector(31 downto 0);
		SD_MD_t : out std_logic;

	-- AiORGBM
		CRT_CLK : in std_logic;
		V_BLANK : out std_logic;
		V_HSYNC : out std_logic;
		V_VSYNC : out std_logic;
		V_R     : out std_logic_vector( 7 downto 0);
		V_G     : out std_logic_vector( 7 downto 0);
		V_B     : out std_logic_vector( 7 downto 0);

	-- COM|[gM
		COM2_TxD : out std_logic;
		COM2_RxD : in std_logic;

	-- LEDM/fBbvXCb`/NMIXCb`
		LED : out std_logic_vector(3 downto 0);
		SW  : in std_logic_vector(3 downto 0);
		NMI : in std_logic;

	-- AVP/IOPԐM
		PIXCLK  : in std_logic;
		FRAME   : in std_logic;
		LINE    : in std_logic;
		DOUT    : in std_logic_vector(7 downto 0);
		SCL_IN  : in std_logic;
		SCL_OUT : out std_logic;
		SDA_IN  : in std_logic;
		SDA_OUT : out std_logic
	);
end CAM_SYS;

architecture RTL of CAM_SYS is

	constant BUFLEN : integer := 32;

	component CRTC
	generic (
		BUFLEN : integer := 32
	);
	port(
		RST    : in std_logic;
		CLK    : in std_logic;
		HSYN   : out std_logic;
		VSYN   : out std_logic;
		BLNK   : out std_logic;
		BUFADR : out integer range 0 to BUFLEN - 1;
		BUFCLR : out std_logic;
		BDI    : in std_logic_vector(31 downto 0);
		YDO    : out std_logic_vector(7 downto 0);
		UDO    : out std_logic_vector(7 downto 0);
		VDO    : out std_logic_vector(7 downto 0)
	);
	end component;

	component YUV2RGB
	port(
		CLK : in std_logic;
		YDI : in std_logic_vector(7 downto 0);
		UDI : in std_logic_vector(7 downto 0);
		VDI : in std_logic_vector(7 downto 0);
		RDO : out std_logic_vector(7 downto 0);
		GDO : out std_logic_vector(7 downto 0);
		BDO : out std_logic_vector(7 downto 0);
		HSI : in std_logic;
		VSI : in std_logic;
		BLI : in std_logic;
		HSO : out std_logic;
		VSO : out std_logic;
		BLO : out std_logic
	);
	end component;

	component CAMC
	generic (
		BUFLEN : integer := 32
	);
	port (
		RST    : in std_logic;
		CLK    : in std_logic;
		LIN    : in std_logic;
		FRM    : in std_logic;
		BUFADR : out integer range 0 to BUFLEN - 1;
		BUFWE  : out std_logic;
		BUFCLR : out std_logic;
		PDI    : in std_logic_vector(7 downto 0);
		BDO    : out std_logic_vector(31 downto 0)
	);
	end component;

	component BUFMEM
	generic (
		BUFLEN : integer := 32
	);
	port (
		WCLK : in std_logic;
		WA   : in integer range 0 to BUFLEN - 1;
		WE   : in std_logic;
		WD   : in std_logic_vector(31 downto 0);
		RCLK : in std_logic;
		RA   : in integer range 0 to BUFLEN - 1;
		RD   : out std_logic_vector(31 downto 0)
	);
	end component;

	component SDRAMC
	generic (
		BUFLEN : integer := 32
	);
	port (
		RST : in std_logic;
		CLK : in std_logic;

		CPUADDR     : in std_logic_vector(23 downto 0);
		CPUWDATA    : in std_logic_vector(7 downto 0);
		CPUWDATASTB : in std_logic;
		CPUWDATABSY : out std_logic;
		CPURDATA    : out std_logic_vector(7 downto 0);
		CPURDATASTB : in std_logic;
		CPURDATABSY : out std_logic;

		CRTBUFFSH : in std_logic;
		CRTBUFCLR : in std_logic;
		CRTBUFADR : out integer range 0 to BUFLEN - 1;
		CRTBUFWE  : out std_logic;
		CRTBUFWD  : out std_logic_vector(31 downto 0);

		CAMBUFFSH : in std_logic;
		CAMBUFCLR : in std_logic;
		CAMBUFADR : out integer range 0 to BUFLEN - 1;
		CAMBUFRD  : in std_logic_vector(31 downto 0);
		CAMSTART  : in std_logic;
		CAMBUSY   : out std_logic;

		SD_LOCK : in std_logic;
		SD_CKE  : out std_logic;
		SD_CS   : out std_logic;
		SD_RAS  : out std_logic;
		SD_CAS  : out std_logic;
		SD_WE   : out std_logic;
		SD_DQM  : out std_logic_vector( 3 downto 0);
		SD_MBA  : out std_logic_vector( 1 downto 0);
		SD_MA   : out std_logic_vector(11 downto 0);
		SD_MD_i : in std_logic_vector(31 downto 0);
		SD_MD_o : out std_logic_vector(31 downto 0);
		SD_MD_t : out std_logic;
		
		DBG_OUT : out std_logic_vector(3 downto 0)
	);
	end component;

	component PROCESSOR
	port (
		RST     : in std_logic;
		CLK     : in std_logic;
		
		MEM_ADDR     : out std_logic_vector(23 downto 0);
		MEM_WDATA    : out std_logic_vector(7 downto 0);
		MEM_WDATASTB : out std_logic;
		MEM_WDATABSY : in std_logic;
		MEM_RDATA    : in std_logic_vector(7 downto 0);
		MEM_RDATASTB : out std_logic;
		MEM_RDATABSY : in std_logic;
		
		CAM_START : out std_logic;
		CAM_BUSY  : in std_logic;
		
		SERIAL_IN  : in std_logic;
		SERIAL_OUT : out std_logic;
		
		SCL_IN  : in std_logic;
		SCL_OUT : out std_logic;
		SDA_IN  : in std_logic;
		SDA_OUT : out std_logic;
		
		LED : out std_logic_vector(3 downto 0);
		SW  : in std_logic_vector(3 downto 0);
		NMI : in std_logic
	);
	end component;

	signal HSYN   : std_logic;
	signal VSYN   : std_logic;
	signal BLNK   : std_logic;
	signal YD     : std_logic_vector(7 downto 0);
	signal UD     : std_logic_vector(7 downto 0);
	signal VD     : std_logic_vector(7 downto 0);

	signal CPUADDR     : std_logic_vector(23 downto 0);
	signal CPUWDATA    : std_logic_vector(7 downto 0);
	signal CPUWDATASTB : std_logic;
	signal CPUWDATABSY : std_logic;
	signal CPURDATA    : std_logic_vector(7 downto 0);
	signal CPURDATASTB : std_logic;
	signal CPURDATABSY : std_logic;

	signal CRTBUFRA  : integer range 0 to BUFLEN - 1;
	signal CRTBUFWA  : integer range 0 to BUFLEN - 1;
	signal CRTBUFRD  : std_logic_vector(31 downto 0);
	signal CRTBUFWD  : std_logic_vector(31 downto 0);
	signal CRTBUFWE  : std_logic;
	signal CRTBUFCLR : std_logic;

	signal CAMBUFRA  : integer range 0 to BUFLEN - 1;
	signal CAMBUFWA  : integer range 0 to BUFLEN - 1;
	signal CAMBUFRD  : std_logic_vector(31 downto 0);
	signal CAMBUFWD  : std_logic_vector(31 downto 0);
	signal CAMBUFWE  : std_logic;
	signal CAMBUFCLR : std_logic;
	signal CAMSTART  : std_logic;
	signal CAMBUSY   : std_logic;

	signal SERIAL_IN  : std_logic;
	signal SERIAL_OUT : std_logic;

begin

	U_CRTC : CRTC
	generic map (
		BUFLEN => BUFLEN
	)
	port map(
		RST    => RST,
		CLK    => CRT_CLK,
		HSYN   => HSYN,
		VSYN   => VSYN,
		BLNK   => BLNK,
		BUFADR => CRTBUFRA,
		BUFCLR => CRTBUFCLR,
		BDI    => CRTBUFRD,
		YDO    => YD,
		UDO    => UD,
		VDO    => VD
	);

	U_YUV2RGB : YUV2RGB port map(
		CLK => CRT_CLK,
		YDI => YD,
		UDI => UD,
		VDI => VD,
		RDO => V_R,
		GDO => V_G,
		BDO => V_B,
		HSI => HSYN,
		VSI => VSYN,
		BLI => BLNK,
		HSO => V_HSYNC,
		VSO => V_VSYNC,
		BLO => V_BLANK
	);

	U_CAMC : CAMC
	generic map(
		BUFLEN => BUFLEN
	)
	port map(
		RST    => RST,
		CLK    => PIXCLK,
		LIN    => LINE,
		FRM    => FRAME,
		BUFADR => CAMBUFWA,
		BUFWE  => CAMBUFWE,
		BUFCLR => CAMBUFCLR,
		PDI    => DOUT,
		BDO    => CAMBUFWD
	);

	U_BUFMEM_CRT : BUFMEM
	generic map(
		BUFLEN => BUFLEN
	)
	port map(
		WCLK => MEM_CLK,
		WA   => CRTBUFWA,
		WE   => CRTBUFWE,
		WD   => CRTBUFWD,
		RCLK => CRT_CLK,
		RA   => CRTBUFRA,
		RD   => CRTBUFRD
	);

	U_BUFMEM_CAM : BUFMEM
	generic map(
		BUFLEN => BUFLEN
	)
	port map(
		WCLK => PIXCLK,
		WA   => CAMBUFWA,
		WE   => CAMBUFWE,
		WD   => CAMBUFWD,
		RCLK => MEM_CLK,
		RA   => CAMBUFRA,
		RD   => CAMBUFRD
	);

	U_SDRAMC : SDRAMC
	generic map(
		BUFLEN => BUFLEN
	)
	port map(
		RST => RST,
		CLK => MEM_CLK,

		CPUADDR     => CPUADDR,
		CPUWDATA    => CPUWDATA,
		CPUWDATASTB => CPUWDATASTB,
		CPUWDATABSY => CPUWDATABSY,
		CPURDATA    => CPURDATA,
		CPURDATASTB => CPURDATASTB,
		CPURDATABSY => CPURDATABSY,

		CRTBUFFSH => VSYN,
		CRTBUFCLR => CRTBUFCLR,
		CRTBUFADR => CRTBUFWA,
		CRTBUFWE  => CRTBUFWE,
		CRTBUFWD  => CRTBUFWD,

		CAMBUFFSH => not FRAME,
		CAMBUFCLR => CAMBUFCLR,
		CAMBUFADR => CAMBUFRA,
		CAMBUFRD  => CAMBUFRD,
		CAMSTART  => CAMSTART,
		CAMBUSY   => CAMBUSY,

		SD_LOCK => SD_LOCK,
		SD_CKE  => SD_CKE,
		SD_CS   => SD_CS,
		SD_RAS  => SD_RAS,
		SD_CAS  => SD_CAS,
		SD_WE   => SD_WE,
		SD_DQM  => SD_DQM,
		SD_MBA  => SD_MBA,
		SD_MA   => SD_MA,
		SD_MD_i => SD_MD_i,
		SD_MD_o => SD_MD_o,
		SD_MD_t => SD_MD_t,
		
		DBG_OUT => open
	);

	U_PROCESSOR : PROCESSOR
	port map(
		RST => RST,
		CLK => MEM_CLK,
		
		MEM_ADDR     => CPUADDR,
		MEM_WDATA    => CPUWDATA,
		MEM_WDATASTB => CPUWDATASTB,
		MEM_WDATABSY => CPUWDATABSY,
		MEM_RDATA    => CPURDATA,
		MEM_RDATASTB => CPURDATASTB,
		MEM_RDATABSY => CPURDATABSY,
		
		CAM_START => CAMSTART,
		CAM_BUSY  => CAMBUSY,
		
		SERIAL_IN  => COM2_RxD,
		SERIAL_OUT => COM2_TxD,
		
		SCL_IN  => SCL_IN,
		SCL_OUT => SCL_OUT,
		SDA_IN  => SDA_IN,
		SDA_OUT => SDA_OUT,
		
		LED => LED,
		SW  => SW,
		NMI => NMI
	);

end RTL;
