
------------------------------------------------------------------------------
-- Title       : bufmem.vhd
-- Description : obt@
-- Author      : KAWAMOTO Yasuhisa
-- Mail        : kawamoto@devdrv.co.jp
-- Date        : 08/09/2007
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity BUFMEM is
	generic (
		BUFLEN : integer := 32
	);
	port (
		WCLK : in std_logic;
		WA   : in integer range 0 to BUFLEN - 1;
		WE   : in std_logic;
		WD   : in std_logic_vector(31 downto 0);
		RCLK : in std_logic;
		RA   : in integer range 0 to BUFLEN - 1;
		RD   : out std_logic_vector(31 downto 0)
	);
end BUFMEM;

architecture RTL of BUFMEM is
	type DEF_BUF is array (0 to BUFLEN - 1) of std_logic_vector(31 downto 0);
	signal BUF : DEF_BUF;
begin

-- obt@Cg
	process (WCLK) begin
		if (WCLK'event and WCLK = '1') then
			if (WE = '1') then
					BUF(WA) <= WD;
			end if;
		end if;
	end process;

-- obt@[h
	process(RCLK) begin
		if (RCLK'event and RCLK = '1') then
			RD <= BUF(RA);
		end if;
	end process;
end RTL;
