#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/workqueue.h>
#include <asm/atomic.h>

static int number;
static atomic_t sync;
static struct workqueue_struct *wq2;
static struct work_struct work;
static struct wq {
	int num;
	char *name;
} wq2_data;

static void deferred_print(void *data)
{
        int val;
	struct wq *wp = (struct wq *)data;

        atomic_inc(&sync);
        while((val = atomic_read(&sync)) <= 1) {
                schedule();
        }
	printk("wq2(%d): deferred_print(%s) = %d [%s]\n",
	       get_cpu(), wp->name, wp->num, current->comm);
	put_cpu();
        atomic_dec(&sync);
}

/*
 * called when user is writing
 */
int wq2_set(const char *val, struct kernel_param *kp)
{
	int l = simple_strtol(val, NULL, 0);
	struct wq *datap = &wq2_data;

	*((int *)kp->arg) = l;
	atomic_set(&sync, 0);
	printk("wq2: write(%d)[%s]: number = %d\n",
	       get_cpu(), current->comm, l);
	put_cpu();
	datap->name = "SET";
	datap->num = l;
        queue_work(wq2, &work);
        queue_work(wq2, &work);
	return 0;
}

/*
 * called when user is reading
 */
int wq2_get(char *buffer, struct kernel_param *kp)
{
	int l = *((int *)kp->arg);
	struct wq *datap = &wq2_data;

	printk("wq2: read(%d)[%s]: number = %d\n",
	       get_cpu(), current->comm, l);
	put_cpu();
	datap->name = "PUT";
	datap->num = l;
        queue_work(wq2, &work);
        queue_work(wq2, &work);
	return sprintf(buffer, "%d", l);
}

static int __init wq2_init_module(void)
{
    printk(KERN_INFO "workq2: init data = %d\n", number);
    wq2 = create_workqueue("wq2d");
    if (!wq2)
	    panic("Failed to create wq2d\n");
    INIT_WORK(&work, deferred_print, &wq2_data);
    return 0;
}

static void __exit wq2_cleanup_module(void)
{
    destroy_workqueue(wq2);
    printk(KERN_INFO "workq2: cleanup data = %d\n", number);
}

MODULE_DESCRIPTION("Sample Wq2 Module");
MODULE_LICENSE("GPL");
MODULE_AUTHOR("Atomu Hidaka <hidaka@devdrv.com>");
module_param_call(number, wq2_set, wq2_get, &number, 0644);
MODULE_INFO(parmtype, "number:int");
MODULE_PARM_DESC(number, "workq2 special number");

module_init(wq2_init_module);
module_exit(wq2_cleanup_module);
