#include <linux/module.h>
#include <linux/device.h>
#include <linux/kdev_t.h>

#define MY_MAJOR 330
struct my_device
{
        struct device *dev;
        char name[32];
        int minor;
        struct class_device class_dev;
};

static struct class my_class = {
        .name    = "my_class",
};

static struct my_device my = {
	.name = "my_device_name",
	.minor = 0,
};

static ssize_t show_name(struct class_device *cd, char *buf)
{
        struct my_device *pmd = container_of(cd, struct my_device, class_dev);
        return sprintf(buf,"%.*s\n",(int)sizeof(pmd->name),pmd->name);
}

static ssize_t show_dev(struct class_device *cd, char *buf)
{
        struct my_device *pmd = container_of(cd, struct my_device, class_dev);
        dev_t dev = MKDEV(MY_MAJOR, pmd->minor);
        return sprintf(buf,"%04x\n",(int)dev);
}

static CLASS_DEVICE_ATTR(name, S_IRUGO, show_name, NULL);
static CLASS_DEVICE_ATTR(dev,  S_IRUGO, show_dev, NULL);

static int mydev_init(void)
{
	struct my_device *pmd = &my;
	class_register(&my_class);
        pmd->class_dev.class = &my_class;
        strlcpy(pmd->class_dev.class_id, "my_device", BUS_ID_SIZE);
        class_device_register(&pmd->class_dev);
        class_device_create_file(&pmd->class_dev,
                                 &class_device_attr_name);
        class_device_create_file(&pmd->class_dev,
                                 &class_device_attr_dev);
	return(0);
}

static void mydev_exit(void)
{
	class_device_unregister(&my.class_dev);
	class_unregister(&my_class);
}

MODULE_LICENSE("GPL");
module_init(mydev_init);
module_exit(mydev_exit);
