#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include <fcntl.h>
#include <termio.h>

#define LOOP_COUNT 1

int fd0;
int fd1;
char wbuf[16] = "5000";
static int loop;

void thread0(char *arg)
{
  int i, len;

  printf("Thread-0 Start.\n");
  for(i = 0; i < loop; i++) {
    len = write(fd0, wbuf, strlen(wbuf));
  }
  close(fd0);
}

void thread1(char *arg)
{
  int i, len;

  printf("Thread-1 Start.\n");
  for(i = 0; i < loop; i++) {
    len = write(fd1, wbuf, strlen(wbuf));
  }
  close(fd1);
}

int main(const int ac, const char **av)
{
  int s;
  pthread_t th0, th1;

  if (ac > 1)
	  loop = atoi(av[1]);
  if (loop == 0)
	  loop = LOOP_COUNT;
	  
  if ((fd0 = open("/proc/loop0", O_WRONLY)) < 0) {
    fprintf(stderr, "th: open error\n");
    exit(1);
  }
  if ((fd1 = open("/proc/loop1", O_WRONLY)) < 0) {
    fprintf(stderr, "th: open error\n");
    exit(1);
  }
  printf("Program Start = %d times.\n", loop);

  if ((s = pthread_create(&th0, NULL, (void*) thread0, NULL)) != 0) {
    printf("th0: create error!\n");
    exit(2);
  }
  if ((s = pthread_create(&th1, NULL, (void*) thread1, NULL)) != 0) {
    printf("th1: create error!\n");
    exit(3);
  }

  if ((s = pthread_join(th0, NULL)) != 0) {
    printf("th0: join error!\n");
    exit(4);
  }
  printf("Thread-0 Exit.\n");
  if ((s = pthread_join(th1, NULL)) != 0) {
    printf("th1: join error!\n");
    exit(5);
  }
  printf("Thread-1 Exit.\n");
  exit(0);
}

/*
compile command:
cc -g -lpthread -o thread thread.c
*/
