#include <linux/config.h>
#include <linux/module.h>

static int sw = 0;
extern int hello_extern(void);

/*
 * called when user writes the parameter
 */
static int hello3_set_sw(const char *val, struct kernel_param *kp)
{
	int v = hello_extern();

	if (val)
		sw = simple_strtol(val, NULL, 0);
	if (sw) {
		printk("%s:set: val = %d, v = %d\n",
		       kp->name, *((int *)kp->arg), v);
		sw += v;
	}
	return 0;
}

/*
 * called when user reads the parameter
 */
static int hello3_get_sw(char *buffer, struct kernel_param *kp)
{
	printk("%s:get: val = <%d>\n", kp->name, *((int *)kp->arg));
	return(param_get_int(buffer, kp));
}

/*
 * initialize and cleanup
 */
static int hello3_init(void)
{
	printk(KERN_INFO "hello3_init\n");
	return 0;
}

static void hello3_exit(void)
{
	printk(KERN_INFO "hello3_exit\n");
}

module_param_call(sw, hello3_set_sw, hello3_get_sw, &sw, 0644);
MODULE_INFO(parmtype, "sw:int");
MODULE_PARM_DESC(sw, "Sw ON=1/OFF=0: 0-1 (default=0)");

MODULE_DESCRIPTION("Sample Hello3 Module");
MODULE_AUTHOR("Atomu Hidaka <hidaka@devdrv.com>");
MODULE_SUPPORTED_DEVICE("/dev/null");
MODULE_ALIAS("super_test");
MODULE_LICENSE("GPL v2");

module_init(hello3_init);
module_exit(hello3_exit);
