/* Copyright(c) 2002,2003 Device Drivers Limited, All rights reserved. */
/*                              info@devdrv.com http://www.devdrv.com/ */
#ifndef __KERNEL__
#  define __KERNEL__
#endif
#ifndef MODULE
#  define MODULE
#endif

#include <linux/config.h>
#include <linux/module.h>
#include <linux/vmalloc.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h>
#include <asm/page.h>

#define BUFFER_SIZE (1024 * 16) /* 16 KB estimates enough for this buffer size */
#if (PAGE_SIZE < BUF_SIZE)
#define BUFFER_SIZE PAGE_SIZE   /* for not enough page size system */
#endif

static char *st_b = NULL; /* data buffer */

struct datas {
	int cmd;
	int length;
	char data[0];
};

/*
 * file_read_proc -- called when user reading
 */
int file_read_proc(char *buf, char **start, off_t offset,
                   int count, int *eof, void *data)
{
	int return_length;

	printk("**file_read_proc(), count = %d, off = %d\n",
	   count, (int) offset);

	return_length = count > BUFFER_SIZE ? BUFFER_SIZE : count;
	memcpy(buf, st_b + offset, return_length);
	*start = buf + offset; /* update next start point */
	return return_length;
}

/*
 * file_write_proc -- called when user writing
 */
int file_write_proc(struct file *file, const char *buf,
		    unsigned long count, void *data)
{
	int i, cmd, length, datalen;
	struct datas *p;
 
	printk("**file_write_proc(), count = %d\n", (int) count);

	length = count > BUFFER_SIZE ? BUFFER_SIZE : count; /* limit of max size */
	copy_from_user(st_b, buf, length);

	for(i = 0; i < length;) {
		p = (struct datas *) &st_b[i];
		cmd = p->cmd;
		datalen = p->length;

		printk("write_file(), cmd = %d, point = %d, datalen = %d, data = %s.\n",
		       cmd, i, datalen, p->data);
		i += datalen + sizeof(struct datas);
	}
	return length;
}

static void file_create_proc()
{
	struct proc_dir_entry *entry;
	entry = create_proc_entry("net/file", 0, 0); /* "file" registration */
	entry->read_proc = file_read_proc;   /* read routine */
	entry->write_proc = file_write_proc; /* write routine */
}

static void file_remove_proc()
{
	remove_proc_entry("net/file", NULL);
}

static int __init procfile_init_module(void)
{
	file_create_proc();
	st_b = (char *) vmalloc(BUFFER_SIZE);
	if (st_b == NULL) {
		printk("File, cannot vmalloc = %d\n", BUFFER_SIZE);
		file_remove_proc();
	}
	printk("** procfile start...\n");
	return 0;
}

static void __exit procfile_cleanup_module(void)
{
	printk("** procfile end...\n");
	if (st_b == NULL) {
		vfree(st_b);
	}
	file_remove_proc();
}

MODULE_DESCRIPTION("Sample Procfile Module");
MODULE_LICENSE("GPL");

module_init(procfile_init_module);
module_exit(procfile_cleanup_module);
