/* Copyright(c) 2002,2003 Device Drivers Limited, All rights reserved. */
/*                              info@devdrv.com http://www.devdrv.com/ */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

char *filename = "/proc/net/file";

/* $B<u$1EO$7%3%^%s%I!&%G!<%?MQ9=B$BN(B */
struct datas {
	int cmd;
	int length;
	char data[0];
};

/* $BFbIt$G$N%G!<%?4IM}MQ$N9=B$BN(B */
struct datachain {
	struct datachain *next;
	struct datas d;
};

/* $B%3%^%s%INs$rJ]4I$9$k%k!<%A%s(B */
struct datachain *
write_buffer(int cmd, void *data, int length)
{ 
	struct datachain *p;

	p = (struct datachain *) malloc(sizeof(struct datachain) + length);
	if (p == NULL) {
		fprintf(stderr, "can\'t malloc()\n");
		exit(1);
	}
	p->d.cmd = cmd;
	p->d.length = length;
	memcpy(&p->d.data[0], data, length);

	return(p);
}
    
static struct datachain *root = NULL;

main()
{
	int fd;
	int i, cmd, total;
	char buf[BUFSIZ];
	char *pp;
	struct datachain *p;
	struct datachain *plast;
	struct datas *ppp;

	fd = open(filename, O_WRONLY);
	if (fd < 0) {
		printf("can\'t open = %s\n", filename);
		exit(1);
	}
	for(i = 0; ; i++) {
		cmd = 0;
		buf[0] = '\0';

		scanf("%d %s", &cmd, buf); /* $B%F%9%HMQ%G!<%?$NF~NO(B */
		if (cmd == 0) /* $B=*N;H=Dj!'(B0 $B$NF~NO$G=*$o$j(B */
			break;
		p = write_buffer(cmd, buf, strlen(buf) + 1);

		p->next = NULL;
		if (root == NULL) { /* $B:G=i$N%A%'%$%s(B */
			root = plast = p;
		}
		else {
			plast = plast->next = p;
		}
	}
	p = root;
	pp = NULL;
	ppp = NULL;
	total = 0;
	/* $B$9$Y$F$N%3%^%s%I!&%G!<%?F~NO8e$K(BPROC$B%U%!%$%k$X=PNO(B */
	for(i = 0; p != NULL; i++) {
		total += p->d.length + sizeof(struct datas);
		printf("%d: tot = %d, cmd = %d, len = %d <%s>\n",
		       i, total, p->d.cmd, p->d.length, p->d.data);

		pp = (char *) realloc(pp, total); /* $B%G!<%?$r$^$H$a$k=hM}(B */
		if (ppp == NULL)
			ppp = (struct datas *) pp;

		ppp->cmd = p->d.cmd;
		ppp->length = p->d.length;
		memcpy(ppp->data, p->d.data, p->d.length);

		ppp = (struct datas *) (pp + total);
		plast = p;
		p = p->next;
		free(plast); /* $B;HMQ:Q$_%P%C%U%!$r3+J|(B */
	}
	write(fd, pp, total); /* $B0l2s$GA4%G!<%?$r=PNO(B */

	free(pp);
	close(fd);
	exit(0);
}
