@echo off

set _INSPECT_MODE_=0
set _BD=
set _BA=
set _UD=
set _USERDIR=\src\usb
set _MYTARGET=rx62n
set _SELDIR=\sel

if /I "%1"=="/I" set _INSPECT_MODE_=1
if "%1"=="/?"       goto :NOTICE
if /I "%1"=="/H"    goto :NOTICE
if /I "%1"=="/Help" goto :NOTICE


if "%BASEDIR%"==""    goto :ERROR 
if "%_BUILDARCH%"=="" goto :ERROR

set _CWD=%CD%
set _USERDIR=%BASEDIR%%_USERDIR%
set _SRCUSB=%BASEDIR%\src\usb
set _MYTANK=%_CWD%%_SELDIR%

:::@echo _CWD === %_CWD%
:::@echo BASEDIR === %BASEDIR%
:::@echo _BUILDARCH === %_BUILDARCH%
:::@echo _INSPECT_MODE_ === %_INSPECT_MODE_%
:::@echo _USER_DIR === %_USERDIR%
:::@echo _MYTARGET === %_MYTARGET%

if NOT EXIST %_MYTANK% goto :ERRORPACKAGE

if NOT EXIST %_USERDIR% goto :ERROR
if NOT EXIST %_SRCUSB%  goto :ERROR

goto :MAIN
:: ---------------------------------------------
:: Help message
:: ---------------------------------------------
:NOTICE
@echo.
@echo Instruction of CQ publishing RX62N device driver training package
@echo.
@echo You must install WDK from Microsoft before this installation.
@echo This script should be started on build environment.
@echo.
@echo Usage INSTALL.CMD [/I][/?^|/H^|/Help]
@echo         /I -- Inspection mode, you can change install and WDK search path.
@echo         /Help -- Help, show this message.
@echo.
@echo.

goto :EOF

:: ---------------------------------------------
:: Inspection
:: ---------------------------------------------
:MAIN
@echo Inspection...

if %_INSPECT_MODE_% == 1 set /p _BD="BASEDIR (%BASEDIR%) ?"
:::@echo _BD === %_BD%
if NOT "%_BD%"=="" set BASEDIR=%_BD%
:::@echo BASEDIR === %BASEDIR%

if %_INSPECT_MODE_% == 1 set /p _BA="BUILDARCH (%_BUILDARCH%) ?"
:::@echo _BD === %_BA%
if NOT "%_BA%"=="" set _BUILDARCH=%_BA%
:::@echo _BUILDARCH === %_BUILDARCH%

if %_INSPECT_MODE_% == 1 set /p _UD="USERDIR (%_USERDIR%) ?"
:::@echo _UD === %_UD%
if NOT "%_UD%"=="" set _USERDIR=%_UD%
:::@echo _USER_DIR === %_USERDIR%


:::@echo BASEDIR === %BASEDIR%
:::@echo _BUILDARCH === %_BUILDARCH%
:::@echo _INSPECT_MODE_ === %_INSPECT_MODE_%
:::@echo _CWD === %_CWD%
:::@echo _USERDIR === %_USERDIR%

if /I "%_BUILDARCH%"=="AMD64" goto :OKCHEK
if /I "%_BUILDARCH%"=="X86" goto :OKCHEK

goto :ERRORPARAMETER

:OKCHEK

:: ---------------------------------------------
:: Making destination directory
:: ---------------------------------------------

@echo.
@echo Making destination directory...
@echo.

cd %_USERDIR%

if EXIST %_MYTARGET% goto :ERRORDIR

mkdir %_MYTARGET%
cd    %_MYTARGET%

mkdir exe
mkdir inc
mkdir rx62n
mkdir umdf

:: ---------------------------------------------
:: Copy base files from my package
:: ---------------------------------------------

@echo.
@echo Copy base files from my package...
@echo.

copy/v/y %_MYTANK%\rx62n.sln    .
copy/v/y %_MYTANK%\pch.txt.gz   .
copy/v/y %_MYTANK%\patch.exe    .
copy/v/y %_MYTANK%\gunzip.exe   .
copy/v/y %_MYTANK%\ddkbuild.cmd    exe
copy/v/y %_MYTANK%\ddkbuild.cmd    rx62n
copy/v/y %_MYTANK%\ddkbuild.cmd    umdf
copy/v/y %_MYTANK%\exe\exe.vcxproj exe
copy/v/y %_MYTANK%\rx62n\rx62n.vcxproj rx62n
copy/v/y %_MYTANK%\umdf\umdf.vcxproj umdf

if /I "%_BUILDARCH%"=="AMD64" (
copy/v/y %_MYTANK%\rx62n\DDKBLD-amd64.BAT     rx62n\DDKBLD.BAT
copy/v/y %_MYTANK%\rx62n\ddkpostbld-amd64.cmd rx62n\ddkpostbld.cmd
copy/v/y %_MYTANK%\umdf\DDKBLD-amd64.BAT      umdf\DDKBLD.BAT
copy/v/y %_MYTANK%\umdf\ddkpostbld-amd64.cmd  umdf\ddkpostbld.cmd
) else (
copy/v/y %_MYTANK%\rx62n\DDKBLD-x86.BAT     rx62n\DDKBLD.BAT
copy/v/y %_MYTANK%\rx62n\ddkpostbld-x86.cmd rx62n\ddkpostbld.cmd
copy/v/y %_MYTANK%\umdf\DDKBLD-x86.BAT      umdf\DDKBLD.BAT
copy/v/y %_MYTANK%\umdf\ddkpostbld-x86.cmd  umdf\ddkpostbld.cmd
)

:: ---------------------------------------------
:: Copy sample files from WDK src
:: ---------------------------------------------

@echo.
@echo Copy sample files from my package...
@echo.

copy/v /y %_SRCUSB%\osrusbfx2\kmdf\exe\makefile exe
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\exe\sources exe
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\exe\testapp.c  exe
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\exe\testapp.rc exe

copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\inc\prototypes.h inc
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\inc\public.h     inc
copy/v /y %_SRCUSB%\osrusbfx2\umdf\inc\list.h           inc
copy/v /y %_SRCUSB%\osrusbfx2\umdf\inc\usb_hw.h         inc

copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\step5\step5.c       rx62n\rx62n.c
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\step5\sources       rx62n\sources
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\step5\makefile      rx62n
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\final\osrusbfx2.inx rx62n\rx62n.inx
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\final\interrupt.c   rx62n
copy/v /y %_SRCUSB%\osrusbfx2\kmdf\sys\final\makefile.inc  rx62n

copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\comsup.cpp       umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\comsup.h         umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\ControlQueue.cpp umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\ControlQueue.h   umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\Device.cpp       umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\Device.h         umdf

copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\dllsup.cpp   umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\Driver.cpp   umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\Driver.h     umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\exports.def  umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\internal.h   umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\makefile     umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\makefile.inc umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\queue.cpp    umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\queue.h      umdf

copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\ReadWriteQueue.cpp umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\ReadWriteQueue.h   umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\comsup.cpp         umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\comsup.cpp         umdf
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\WUDFOsrUsbFx2.inx  umdf\rx62n_umdf.inx
copy/v /y %_SRCUSB%\osrusbfx2\umdf\fx2_driver\final\sources            umdf

:: ---------------------------------------------
:: Patch sample files
:: ---------------------------------------------

@echo.
@echo Patch sample files...
@echo.

gunzip -c pch.txt.gz | patch.exe -p1


goto :EXIT

:ERRORPARAMETER
@echo.
@echo Error - Install package (%_MYTANK%) doesn't exists.
@echo         Check package and try again.
@echo.
@echo.

goto :EXIT

:ERRORPACKAGE
@echo.
@echo Error - Install package (%_MYTANK%) doesn't exists.
@echo         Check package and try again.
@echo.
@echo.

goto :EXIT

:ERRORDIR
@echo.
@echo Error - Install directory (%_USERDIR%\%_MYTARGET%) alredy exists.
@echo         Check directory and try again.
@echo.
@echo.

goto :SKIPREMOVE

:ERROR
@echo.
@echo Error - This should be start on WDK Build Environments.
@echo         Install WDK and try again.
@echo.
@echo.

goto :EOF

:EXIT

:: ---------------------------------------------
:: Remove package files
:: ---------------------------------------------

@echo.
@echo Remove package files...
@echo.

del/f pch.txt.gz patch.exe gunzip.exe

:SKIPREMOVE
::::@echo cd %_CWD%
cd %_CWD%

set _INSPECT_MODE_=
set _BD=
set _BA=
set _UD=
set _USERDIR=
set _MYTARGET=
set _SELDIR=
set _CWD=
set _USERDIR=
set _SRCUSB=
set _MYTANK=
